##
#TESTRANGE
testStr = "fabricskyboxes:sky/OverworldLoruhnSet_bottom.png"

if ".png" in testStr and r"fabricskyboxes:sky/" in testStr :
    print("yup everything is working fine")

##
import os
import json

files = [f for f in os.listdir('.') if os.path.isfile(f)]
for file in files:
    if file.endswith(".json") :
        print("## Commencing formatting of file : " + file)
        print()
        with open(file, 'r') as f :
            sky = json.load(f)
            allFileNames=[]
            for tex in sky["textures"] :
                if sky["textures"][tex].lower() != sky["textures"][tex] :
                    new_name = sky["textures"][tex].lower()
                    print(sky["textures"][tex] + " ---> " + new_name)
                    sky["textures"][tex] = new_name
                else :
                    print(sky["textures"][tex] + " already lowercase")
            for deco in sky["decorations"]:
                sky["decorations"][deco] = False
            if "worlds" in sky["conditions"].keys():
                del sky["conditions"]["worlds"]
            if "dimensions" in sky["conditions"].keys():
                del sky["conditions"]["dimensions"]

            texture = (sky["textures"]["top"].split("_")[0]).split(":sky/")[1]
            if texture in allFileNames :
                n=2
                while texture in allFileNames :
                    texture += str(n)
                    n+=1
            allFileNames.append(texture)
        with open(file, "w") as f:
            json.dump(sky,f,indent=4)
            os.rename(file, f"./{texture}.json")
            print()
            print(f"Finished ! Saved as {texture}")
            print()
