##
import os
import json

dirs = [f for f in os.listdir('../optifine/ctm')]
for dir in dirs:
    files = [f for f in os.listdir(f'../optifine/ctm/{dir}') if f.endswith(".properties")]
    for file in files:
        if file.startswith("cobweb") :
            break
        print(file)
        with open(f'../optifine/ctm/{dir}/{file}', "r") as f:
            name = f.name
            og = f.readlines()
        data = {}
        for line in og:
            property = line.split("\n")[0].split("=")
            data[property[0]] = property[1].split() if property[0] == "biomes" else property[1]

        block_name = data["matchTiles"]
        texture_name = data["tiles"]
        biome_list = data["biomes"]
        biome_list_rev = []

        overrides = []

        for bio in biome_list :
            biomeCond = {
                "biome": bio
            }
            overR={
                "when" : biomeCond,
                "apply": f"minecraft:{dir}_{block_name}"
            }
            overrides.append(overR)
            biomeCond = {}

        model = {
            "parent": "minecraft:block/cube_all",
            "textures": {
                "all": f"minecraft:mbp/{dir}_{texture_name}"
            }
        }

        alreadyDone = [f for f in os.listdir('.') if f.endswith(".json")]
        if f"{block_name}.json" in alreadyDone :
            print(f"{block_name} already in properties ! Adding to the file...")
            with open(f"./{block_name}.json", "r") as f:
                already = json.load(f)
            for o in overrides :
                already["overrides"].append(o)
            with open(f"../models/block/{dir}_{block_name}.json", "w+") as f:
                json.dump(model,f,indent=4)
            with open(f"./{block_name}.json", "w") as f:
                json.dump(already,f,indent=4)
        else :
            predicate = {
                "overrides":overrides
            }
            with open(f"../models/block/{dir}_{block_name}.json", "w+") as f:
                json.dump(model,f,indent=4)
            with open(f"./{block_name}.json", "w+") as f:
                json.dump(predicate,f,indent=4)

        print(f"Task complete : {dir}_{block_name}")