#version 150

#moj_import <matrix.glsl>

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;

uniform float GameTime;
uniform int EndPortalLayers;

in vec4 texProj0;

const vec3[] COLORS = vec3[](
    vec3(100, 100, 5),
    vec3(95, 95, 7),
    vec3(90, 90, 0),
    vec3(54, 4, 59),
    vec3(30, 2, 38),
    vec3(32, 3, 38),
    vec3(38, 38, 3),
    vec3(100, 0, 150),
    vec3(80, 0, 100),
    vec3(60, 1, 80),
    vec3(40, 2, 60),
    vec3(224, 196, 11),
    vec3(100, 100, 3),
    vec3(140, 6, 207),
    vec3(100, 100, 3),
    vec3(140, 6, 207)
);

const mat4 SCALE_TRANSLATE = mat4(
    0.5, 0.0, 0.0, 0.25,
    0.0, 0.5, 0.0, 0.25,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0
);

vec3 grayscale(vec3 color_in) {
    return vec3(color_in.x + color_in.y + color_in.z / 3.0);
}

mat4 end_portal_layer(float layer) {
    mat4 translate = mat4(
        1.0, 0.0, 0.0, 17.0 / layer,
        0.0, 1.0, 0.0, (2.0 + layer / 1.5) * (GameTime * 1.5),
        0.0, 0.0, 1.0, 0.0,
        0.0, 0.0, 0.0, 1.0
    );

    mat2 rotate = mat2_rotate_z(radians((layer * layer * 4321.0 + layer * 9.0) * 2.0));

    mat2 scale = mat2((4.5 - layer / 4.0) * 2.0);

    return mat4(scale * rotate) * translate * SCALE_TRANSLATE;
}

out vec4 fragColor;

void main() {
    vec3 color = grayscale(textureProj(Sampler0, texProj0).rgb) / 3.0;
    for (int i = 0; i < EndPortalLayers; i++) {
        color += textureProj(Sampler1, texProj0 * end_portal_layer(float(i + 1))).rgb * (COLORS[i] / 255.0);
    }
    fragColor = vec4(color, 1.0);
}
